/** @file   warglobals.h
 * @brief   Declarations of the globals.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 22:03:28 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_WARGLOBALS_H
#define H_WWW_WARGLOBALS_H

#include <vector>
#include "bonusobject.h"
#include "player.h"
#include "statistics.h"
#include "level.h"
#include "objectstorage.h"
#include "hud.h"
#include "eng2d.h"
#include "teleporter.h"
#include "bullettable.h"
#include "shadowmanager.h"


namespace WeWantWar {

// Let the compiler know about these classes
class Door;
class GameObject;
class WeaponGuide;
class BonusObject;


/** @class  WarGlobals
 * @brief   Holds the global object-tables so that they can be accessed from
 *          other classes.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 *
 * WarGlobals-class manages the global datastructures of the actionpart.
 * The GameObjects, BonusLists and Door-tables are stored here.
 */
class WarGlobals
{
public:

  /** All the bonusitems are here. */
  static std::vector<BonusObject*>  bonusList;
  /** All the door-objects are here. */
  static std::vector<Door*> doorList;
  /** All the teleporters are stored in this vector. */
  static std::vector<Teleporter*> teleporterList;

  /** As the War-object creates the object table it places the pointer to that
   * ObjectStorage in this member.
   */
  static ObjectStorage* pObjTable;
  
  /** Pointer to Hud - object. The War::prepareLevel(int ) - method initializes
   * this.
   */
  static Hud* pHud;
  
  /** Pointer to current Level. The War::prepareLevel(int ) - method
   * initializes this.
   */
  static Level* pLevel;
  
  /** Pointer to an object that manages the currently flying bullets and
   * grenades.
   */
  static BulletTable* pBulletManager;
  
  /** The Dynamic Shadows */
  static ShadowManager* pShadowManager;
  
  /** This object manages the statistics */
  static Statistics gameStats;
  
  /** Number of lives we have */
  static int numberOfLives;
  
  /** As we start the new level, the maximum timebonuses are placed here */
  static int timeBonuses;
  
  /** A flag that tells if bullettime is on */
  static bool bulletTimeMode;
  /** Amount of time bullettime left. */
  static int bulletTimeLeft;
  
  /** Is the screenlock on or off. When the screen is locked, it does not
   * scroll as the player moves. The player cannot go outside the screen
   * though.
   */
  static bool screenLockMode;
  /** The coordinate where the screen will be locked. */
  static eng2d::Vec2D screenLockPos;
  
  /** The ParticleManager for blood and other effects. */
  static eng2d::ParticleManager* pPartManager;
  
  static eng2d::LightFenceManager* pFenceManager;

  
  /** This flag controls if player can even try to capture or exit a
   * vehicle.
   */
  static bool captureFeatureOn;

  /** Set when player wants to capture/exit a vehicle */
  static bool captureVehicle;

  /** Set, when we're operating in Free Scroll Mode. Then, we can scroll the
   * screen freely with arrow keys.
   */
  static bool freeScrollMode;

  
  ///
  /// Static methods
  /// ==============
  
  /** Initializes the WarGlobals - members. Creates the ParticleManager,
   * LightFenceManager, Hud and ObjectStorage.
   */
  static void initGlobals();
  
  /** Removes the globals. Destroyes the objects created in
   * @c initGlobals() - method.
   */
  static void cleanupGlobals();
  
  /** Inits the WarGlobals. This must be called after you've loaded a new
   * map. This prepares the objects for use.
   */
  static void prepareObjects();
  
  /** Releases the resources allocated for the objects.
   */
  static void cleanup();
  
  /** Increases the bullet time
   */
  static void increaseBulletTime( int amount );
  
  
  /** Adds new bonusitem to bonuslist.
   * @param     pB                Pointer to bonusitem
   */
  static void addBonusObject( BonusObject* pB );
  
};


};  // end of namespace

#endif


/**
 * Version history
 * ===============
 * $Log: warglobals.h,v $
 * Revision 1.2  2006/02/08 22:03:28  lamminsa
 * New animation and graphic system was implemented.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:19+02  lamminsa
 * Initial revision
 *
 */
 
